/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.api.model;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

import java.util.ArrayList;
import java.util.List;

import static java.util.Arrays.asList;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.jupiter.params.provider.Arguments.arguments;

class AdditionalPluginDependenciesTestCase {

  private static final String GROUP_ID = "groupId";
  private static final String ARTIFACT_ID = "artifactId";
  private static final List<BundleDescriptor> NO_DEPENDENCIES = new ArrayList<>();
  private static final AdditionalPluginDependencies PLUGIN_DEPENDENCIES =
      new AdditionalPluginDependencies(GROUP_ID, ARTIFACT_ID, NO_DEPENDENCIES);
  private static final String GROUP_ID_2 = "groupId2";
  private static final AdditionalPluginDependencies OTHER_GROUP =
      new AdditionalPluginDependencies(GROUP_ID_2, ARTIFACT_ID, NO_DEPENDENCIES);
  private static final List<BundleDescriptor> ADDITIONAL_DEPENDENCIES = asList(new BundleDescriptor());
  private static final AdditionalPluginDependencies WITH_ADDITIONAL =
      new AdditionalPluginDependencies(GROUP_ID, ARTIFACT_ID, ADDITIONAL_DEPENDENCIES);
  private static final String ARTIFACT_ID_2 = "artifactId2";
  private static final AdditionalPluginDependencies OTHER_ARTIFACT =
      new AdditionalPluginDependencies(GROUP_ID, ARTIFACT_ID_2, NO_DEPENDENCIES);

  @Test
  void testToString() {
    assertThat(WITH_ADDITIONAL.toString(), is("groupId:artifactId"));
  }

  @ParameterizedTest(name = "{index}: equals for object")
  @MethodSource("equals_data")
  void testEquals(AdditionalPluginDependencies o1, Object o2, boolean expectedResult) {
    assertThat(o1.equals(o2), is(expectedResult));
  }

  @ParameterizedTest(name = "{index}: hashCode for object")
  @MethodSource("equals_data")
  void testHashCode(AdditionalPluginDependencies dependencies, Object other, boolean expected) {
    assertThat(dependencies.hashCode() == (other == null ? 0 : other.hashCode()), is(expected));
  }

  static List<Arguments> equals_data() {
    return asList(
                  arguments(PLUGIN_DEPENDENCIES, null, false),
                  arguments(PLUGIN_DEPENDENCIES, new Object(), false),
                  arguments(PLUGIN_DEPENDENCIES, PLUGIN_DEPENDENCIES, true),
                  // We don't consider the bundle descriptor
                  arguments(PLUGIN_DEPENDENCIES, WITH_ADDITIONAL, true),
                  // We do consider the group id
                  arguments(PLUGIN_DEPENDENCIES, OTHER_GROUP, false),
                  // We do consider the artifact id
                  arguments(PLUGIN_DEPENDENCIES, OTHER_ARTIFACT, false));
  }
}
