/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.internal;

import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;

import java.io.File;
import java.nio.file.Path;
import java.util.List;

public class MuleMavenPomParserProvider implements MavenPomParserProvider {

  @Override
  public MavenPomParser createMavenPomParserClient(Path path) {
    return new MavenPomParserImpl(path);
  }

  @Override
  public MavenPomParser createMavenPomParserClient(Path path, List<String> activeProfiles) {
    return new MavenPomParserImpl(path, activeProfiles);
  }
}
