/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.internal.model;

import org.mule.maven.pom.parser.api.model.MavenModelBuilder;
import org.mule.maven.pom.parser.api.model.MavenModelBuilderProvider;

import java.nio.file.Path;
import java.util.Optional;

public class MuleMavenModelBuilderProvider implements MavenModelBuilderProvider {

  @Override
  public MavenModelBuilder createMavenModelBuilder(String groupId, String artifactId, String version,
                                                   Optional<String> modelVersion, Optional<String> packaging) {
    return new MavenModelBuilderImpl(groupId, artifactId, version, modelVersion, packaging);
  }

  @Override
  public MavenModelBuilder createMavenModelBuilder(Path path) {
    return new MavenModelBuilderImpl(path);
  }
}
