/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import java.util.Objects;

/**
 * Specify if a field is read only or write only.
 */
public class AccessibilityAnnotation implements TypeAnnotation
{

    public static final String NAME = "visibility";
    private final Accessibility accessibility;

    public AccessibilityAnnotation(Accessibility accessibility)
    {
        if (accessibility == null)
        {
            throw new IllegalArgumentException("accessibility cannot be null");
        }

        this.accessibility = accessibility;
    }

    public Accessibility getAccessibility()
    {
        return accessibility;
    }

    @Override
    public String getName()
    {
        return NAME;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj instanceof AccessibilityAnnotation)
        {
            return Objects.equals(accessibility, ((AccessibilityAnnotation) obj).accessibility);
        }

        return false;
    }

    @Override
    public int hashCode()
    {
        return accessibility.hashCode();
    }
}
