/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.LinkedList;
import java.util.List;

public abstract class AbstractBuilder<T extends MetadataType> implements TypeBuilder<T>
{

    protected final List<TypeAnnotation> annotations = new LinkedList<>();
    protected final MetadataFormat format;

    protected AbstractBuilder(MetadataFormat format)
    {
        if (format == null)
        {
            throw new IllegalArgumentException("format cannot be null");
        }
        this.format = format;
    }

    protected void addExtension(TypeAnnotation extension)
    {
        this.annotations.add(extension);
    }

}
