/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.impl.DefaultStringType;

import java.util.Optional;

public class StringTypeBuilder<P extends TypeBuilder> extends AbstractBuilder<StringType> implements TypeBuilder<StringType>, WithAnnotation<StringTypeBuilder>
{

    protected StringTypeBuilder(MetadataFormat format)
    {
        super(format);
    }

    public StringTypeBuilder<P> with(TypeAnnotation extension)
    {
        this.addExtension(extension);
        return this;
    }

    public StringTypeBuilder<P> id(String typeIdentifier)
    {
        return with(new TypeIdAnnotation(typeIdentifier));
    }

    public StringTypeBuilder<P> defaultValue(String defaultValue)
    {
        return with(new DefaultValueAnnotation(defaultValue));
    }

    public StringTypeBuilder<P> enumOf(String... values)
    {
        return with(new EnumAnnotation<>(values));
    }

    public StringTypeBuilder<P> pattern(String pattern)
    {
        return with(new RegexPatternAnnotation(pattern));
    }

    @Override
    public DefaultStringType build()
    {
        return new DefaultStringType(format, annotations);
    }

    public StringTypeBuilder<P> boundary(Optional<? extends Number> minLength,
                                         Optional<? extends Number> maxLength)
    {
        return with(new LengthAnnotation(minLength, maxLength));
    }

    public StringTypeBuilder<P> length(Integer length)
    {
        return with(new LengthAnnotation(Optional.of(length), Optional.of(length)));
    }
}
