/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.TypeAnnotation;

/**
 * Identifies a builder with the capability of add {@link TypeAnnotation}s
 *
 * @param <T> concrete {@link TypeBuilder} type
 * @since 1.0
 */
public interface WithAnnotation<T extends TypeBuilder>
{

    /**
     * Contributes a builder with {@link TypeAnnotation}s
     *
     * @param typeAnnotation {@link TypeAnnotation} to add
     * @return contributed {@param <T>} builder
     */
    T with(TypeAnnotation typeAnnotation);
}
