/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Collection;
import java.util.Optional;

/**
 * Base interface for all the Types
 */
public interface MetadataType
{

    /**
     * Return the format of the underlying type system where this type was
     * mapped from. I.E XML
     *
     * @return The format.
     */
    MetadataFormat getMetadataFormat();

    /**
     * Returns all the annotations of a given type
     *
     * @param annotation The type of annotation
     * @return The collection of all the matched annotations.
     */
    <T extends TypeAnnotation> Collection<T> getAnnotation(Class<T> annotation);

    /**
     * Returns all the annotations of the type.
     *
     * @return The collection of annotations
     */
    Collection<TypeAnnotation> getAnnotations();

    /**
     * Returns the description if specified.
     *
     * @return The description if any.
     */
    Optional<String> getDescription();

    /**
     * Dispatches in a reflective way to the method with prefix "visit" with the specific type as argument.
     * Example {@code visitObject(ObjectType objectType) } will be called when this type is an ObjectType.
     * @param visitor The visitor
     */
    void accept(MetadataTypeVisitor visitor);
}
