/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

/**
 * Represents a key value pair of an object field.
 */
public interface ObjectFieldType extends MetadataType
{

    /**
     * The key of this field
     * 
     * @return The key
     */
    ObjectKeyType getKey();

    /**
     * If the field is required or not
     * 
     * @return True if is required
     */
    boolean isRequired();

    /**
     * If this field can be present more than once in an object
     * 
     * @return True if it can be repeated
     */
    boolean isRepeated();

    /**
     * The value of this field
     * 
     * @return The value
     */
    MetadataType getValue();
}
