/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class BaseMetadataType implements MetadataType
{

    private final Collection<TypeAnnotation> annotations;
    private final MetadataFormat metadataFormat;

    public BaseMetadataType(MetadataFormat metadataFormat, Collection<TypeAnnotation> annotations)
    {
        this.metadataFormat = metadataFormat;
        this.annotations = annotations;
    }

    public Collection<TypeAnnotation> getAnnotations()
    {
        return annotations;
    }

    public MetadataFormat getMetadataFormat()
    {
        return metadataFormat;
    }

    public <T extends TypeAnnotation> Collection<T> getAnnotation(Class<T> extension)
    {
        return annotations.stream()
                         .filter((annotation) -> extension.isAssignableFrom(annotation.getClass()))
                         .map(annotation -> extension.cast(annotation))
                         .collect(Collectors.toList());
    }

    @Override
    public Optional<String> getDescription()
    {
        return getAnnotation(DescriptionAnnotation.class).stream().findFirst().map(DescriptionAnnotation::getValue);
    }

    @Override
    public boolean equals(Object obj)
    {
        if (!getClass().isInstance(obj))
        {
            return false;
        }

        return EqualsBuilder.reflectionEquals(this, obj);
    }

    @Override
    public int hashCode()
    {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public String toString()
    {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}
