/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Collection;
import java.util.function.Supplier;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DefaultArrayType extends BaseMetadataType implements ArrayType
{

    private static final String EXCLUDED_FIELD = "type";
    private Supplier<MetadataType> type;

    public DefaultArrayType(Supplier<MetadataType> type, MetadataFormat metadataFormat, Collection<TypeAnnotation> extensions)
    {
        super(metadataFormat, extensions);
        this.type = type;
    }

    @Override
    public MetadataType getType()
    {
        return type.get();
    }

    @Override
    public void accept(MetadataTypeVisitor visitor)
    {
        visitor.visitArrayType(this);
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (!(o instanceof DefaultArrayType))
        {
            return false;
        }
        DefaultArrayType that = (DefaultArrayType) o;
        return EqualsBuilder.reflectionEquals(this, o, EXCLUDED_FIELD) && this.getType().equals(that.getType());
    }

    @Override
    public int hashCode()
    {
        return HashCodeBuilder.reflectionHashCode(this, EXCLUDED_FIELD) * getType().hashCode();
    }
}
