/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;

import javax.xml.namespace.QName;

public class DefaultAttributeKeyType extends BaseMetadataType implements AttributeKeyType
{

    private Optional<QName> name;
    private Optional<Pattern> pattern;

    public DefaultAttributeKeyType(Optional<QName> name, Optional<Pattern> pattern, MetadataFormat metadataFormat, Collection<TypeAnnotation> extensions)
    {
        super(metadataFormat, extensions);
        this.name = name;
        this.pattern = pattern;
    }

    @Override
    public QName getName()
    {
        return name.get();
    }

    @Override
    public Pattern getPattern()
    {
        return pattern.get();
    }

    @Override
    public boolean isName()
    {
        return name.isPresent();
    }

    @Override
    public boolean isPattern()
    {
        return pattern.isPresent();
    }

    @Override
    public void accept(MetadataTypeVisitor visitor)
    {
        visitor.visitAttributeKey(this);
    }
}
