/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.utils;

import java.util.concurrent.Callable;

public class LazyValue<T>
{

    private T value;

    public LazyValue()
    {
    }

    public boolean isDefined()
    {
        return value != null;
    }

    public T get(Callable<T> loadFunction)
    {
        if (value == null)
        {
            try
            {
                value = loadFunction.call();
            }
            catch (Exception e)
            {
                throw new RuntimeException(e);
            }
        }
        return value;
    }
}
