/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.impl.DefaultAttributeFieldType;
import org.mule.metadata.api.model.impl.DefaultAttributeKeyType;

public class AttributeFieldTypeBuilder<P extends TypeBuilder>
extends AbstractBuilder<AttributeFieldType>
implements TypeBuilder<AttributeFieldType> {
    private Optional<QName> name = Optional.empty();
    private Optional<Pattern> pattern = Optional.empty();
    private Optional<TypeBuilder<?>> value = Optional.empty();
    private boolean required = false;

    protected AttributeFieldTypeBuilder(MetadataFormat format) {
        super(format);
    }

    public AttributeFieldTypeBuilder<P> name(QName name) {
        this.name = Optional.of(name);
        return this;
    }

    public AttributeFieldTypeBuilder<P> name(String name) {
        this.name = Optional.of(new QName(name));
        return this;
    }

    public AttributeFieldTypeBuilder<P> pattern(Pattern pattern) {
        this.pattern = Optional.of(pattern);
        return this;
    }

    public BaseTypeBuilder<AttributeFieldTypeBuilder<P>> value() {
        BaseTypeBuilder<AttributeFieldTypeBuilder<P>> typeBuilder = new BaseTypeBuilder<AttributeFieldTypeBuilder<P>>(this.format);
        this.value = Optional.of(typeBuilder);
        return typeBuilder;
    }

    public AttributeFieldTypeBuilder<P> value(TypeBuilder baseTypeBuilder) {
        this.value = Optional.of(baseTypeBuilder);
        return this;
    }

    public void required(boolean required) {
        this.required = required;
    }

    @Override
    public AttributeFieldType build() {
        if (!this.name.isPresent() && !this.pattern.isPresent()) {
            throw new RuntimeException("No name or pattern was specified.");
        }
        TypeBuilder<?> typeBuilder = this.value.orElseThrow(() -> new RuntimeException("No value was specified."));
        Object build = typeBuilder.build();
        if (!(build instanceof SimpleType)) {
            throw new RuntimeException("Value should be a simple type.");
        }
        DefaultAttributeKeyType key = new DefaultAttributeKeyType(this.name, this.pattern, this.format, Collections.emptyList());
        return new DefaultAttributeFieldType(key, (SimpleType)build, this.required, this.format, this.annotations);
    }
}

