/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.Optional;
import org.mule.metadata.api.builder.AnyTypeBuilder;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BinaryTypeBuilder;
import org.mule.metadata.api.builder.BooleanTypeBuilder;
import org.mule.metadata.api.builder.DateTimeBuilder;
import org.mule.metadata.api.builder.DateTypeBuilder;
import org.mule.metadata.api.builder.DictionaryTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.NullTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.SimpleTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TimeTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

public class BaseTypeBuilder<P extends TypeBuilder>
implements TypeBuilder<MetadataType>,
SimpleTypeBuilder<MetadataType> {
    private MetadataFormat format;
    private Optional<TypeBuilder<?>> builder;

    public BaseTypeBuilder(MetadataFormat format) {
        this.format = format;
        this.builder = Optional.empty();
    }

    public BaseTypeBuilder withFormat(MetadataFormat format) {
        this.format = format;
        return this;
    }

    public ObjectTypeBuilder<BaseTypeBuilder<P>> objectType() {
        ObjectTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new ObjectTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    public ArrayTypeBuilder<BaseTypeBuilder<P>> arrayType() {
        ArrayTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new ArrayTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    public DictionaryTypeBuilder<BaseTypeBuilder<P>> dictionaryType() {
        DictionaryTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new DictionaryTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    public UnionTypeBuilder<BaseTypeBuilder<P>> unionType() {
        UnionTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new UnionTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    public TupleTypeBuilder<BaseTypeBuilder<P>> tupleType() {
        TupleTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new TupleTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public StringTypeBuilder<BaseTypeBuilder<P>> stringType() {
        StringTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new StringTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public BooleanTypeBuilder<BaseTypeBuilder<P>> booleanType() {
        BooleanTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new BooleanTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public NumberTypeBuilder<BaseTypeBuilder<P>> numberType() {
        NumberTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new NumberTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public DateTimeBuilder<BaseTypeBuilder<P>> dateTimeType() {
        DateTimeBuilder<BaseTypeBuilder<P>> metadataBuilder = new DateTimeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public DateTypeBuilder<BaseTypeBuilder<P>> dateType() {
        DateTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new DateTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    public TimeTypeBuilder<BaseTypeBuilder<P>> timeType() {
        TimeTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new TimeTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public AnyTypeBuilder<BaseTypeBuilder<P>> anyType() {
        AnyTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new AnyTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public BinaryTypeBuilder<BaseTypeBuilder<P>> binaryType() {
        BinaryTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new BinaryTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public NullTypeBuilder<BaseTypeBuilder<P>> nullType() {
        NullTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new NullTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    public IntersectionTypeBuilder<BaseTypeBuilder<P>> intersectionType() {
        IntersectionTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new IntersectionTypeBuilder<BaseTypeBuilder<P>>(this.format);
        this.builder = Optional.of(metadataBuilder);
        return metadataBuilder;
    }

    @Override
    public MetadataType build() {
        return this.builder.orElseThrow(() -> new RuntimeException("No type was specified.")).build();
    }

    public static BaseTypeBuilder<?> create(MetadataFormat format) {
        return new BaseTypeBuilder(format);
    }
}

