/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

public abstract class BaseMetadataType
implements MetadataType {
    private final Collection<TypeAnnotation> annotations;
    private final MetadataFormat metadataFormat;

    public BaseMetadataType(MetadataFormat metadataFormat, Collection<TypeAnnotation> annotations) {
        this.metadataFormat = metadataFormat;
        this.annotations = annotations;
    }

    @Override
    public Collection<TypeAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public MetadataFormat getMetadataFormat() {
        return this.metadataFormat;
    }

    @Override
    public <T extends TypeAnnotation> Collection<T> getAnnotation(Class<T> extension) {
        return this.annotations.stream().filter(annotation -> extension.isAssignableFrom(annotation.getClass())).map(annotation -> (TypeAnnotation)extension.cast(annotation)).collect(Collectors.toList());
    }

    @Override
    public Optional<String> getDescription() {
        return this.getAnnotation(DescriptionAnnotation.class).stream().findFirst().map(DescriptionAnnotation::getValue);
    }

    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

