/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class DefaultObjectKeyType
extends BaseMetadataType
implements ObjectKeyType {
    private Optional<QName> name;
    private Optional<Pattern> pattern;
    private Collection<AttributeFieldType> attributes;

    public DefaultObjectKeyType(Optional<QName> name, Optional<Pattern> pattern, Collection<AttributeFieldType> attributes, MetadataFormat metadataFormat, Collection<TypeAnnotation> extensions) {
        super(metadataFormat, extensions);
        this.name = name;
        this.pattern = pattern;
        this.attributes = attributes;
    }

    @Override
    public QName getName() {
        return this.name.get();
    }

    @Override
    public boolean isName() {
        return this.name.isPresent();
    }

    @Override
    public Pattern getPattern() {
        return this.pattern.get();
    }

    @Override
    public boolean isPattern() {
        return this.pattern.isPresent();
    }

    public Optional<String> getLabel() {
        return this.getAnnotation(LabelAnnotation.class).stream().findFirst().map(label -> label.getValue());
    }

    @Override
    public Collection<AttributeFieldType> getAttributes() {
        return this.attributes;
    }

    @Override
    public void accept(MetadataTypeVisitor visitor) {
        visitor.visitObjectKey(this);
    }
}

