/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.util.Collection;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class DefaultObjectType
extends BaseMetadataType
implements ObjectType {
    private Collection<ObjectFieldType> fields;
    private boolean ordered;

    public DefaultObjectType(Collection<ObjectFieldType> fields, boolean ordered, MetadataFormat metadataFormat, Collection<TypeAnnotation> extensions) {
        super(metadataFormat, extensions);
        this.fields = fields;
        this.ordered = ordered;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Collection<ObjectFieldType> getFields() {
        return this.fields;
    }

    @Override
    public Optional<ObjectFieldType> getFieldByName(String propertyName) {
        return this.fields.stream().filter(propertyType -> {
            ObjectKeyType key = propertyType.getKey();
            return key.isName() && key.getName().getLocalPart().equals(propertyName);
        }).findFirst();
    }

    @Override
    public void accept(MetadataTypeVisitor visitor) {
        visitor.visitObject(this);
    }
}

