/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import org.mule.metadata.utils.MetadataTypeUtils;

import java.util.Objects;
import java.util.Optional;

import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Adds a description to the annotated type.
 */
public class DescriptionAnnotation implements TypeAnnotation {

  public static final String NAME = "description";
  private final Optional<String> lang;
  private final String value;

  public DescriptionAnnotation(Optional<String> lang, String value) {
    this.lang = lang;
    this.value = value;
  }

  public Optional<String> getLang() {
    return lang;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof DescriptionAnnotation) {
      DescriptionAnnotation other = (DescriptionAnnotation) obj;
      return Objects.equals(value, other.getValue()) && MetadataTypeUtils.equals(lang, other.getLang());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(value).append(MetadataTypeUtils.hashCode(lang)).toHashCode();
  }
}
