/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import org.mule.metadata.utils.MetadataTypeUtils;

import java.util.Optional;

/**
 * Constrain for minimum and maximum repetitions of a field.
 */
public class FieldOccurrenceAnnotation implements TypeAnnotation {

  public static final String NAME = "occurrence";
  private final Optional<? extends Number> min;
  private final Optional<? extends Number> max;

  public FieldOccurrenceAnnotation(Optional<? extends Number> min, Optional<? extends Number> max) {
    this.min = min;
    this.max = max;
  }

  public Optional<? extends Number> getMin() {
    return min;
  }

  public Optional<? extends Number> getMax() {
    return max;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof FieldOccurrenceAnnotation) {
      FieldOccurrenceAnnotation other = (FieldOccurrenceAnnotation) obj;
      return MetadataTypeUtils.equals((Optional<Number>) min, (Optional<Number>) other.getMin()) &&
          MetadataTypeUtils.equals((Optional<Number>) max, (Optional<Number>) other.getMax());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return MetadataTypeUtils.hashCode((Optional<Number>) min, (Optional<Number>) max);
  }
}
