/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import org.mule.metadata.utils.MetadataTypeUtils;

import java.util.Optional;

/**
 * Constrain for number specifying the range where this number is valid.
 */
public class NumberRangeAnnotation implements TypeAnnotation {

  public static final String NAME = "range";
  private final Optional<Number> from;
  private final Optional<Number> to;

  public NumberRangeAnnotation(Optional<Number> from, Optional<Number> to) {
    this.from = from;
    this.to = to;
  }

  public Optional<Number> getFrom() {
    return from;
  }

  public Optional<Number> getTo() {
    return to;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof NumberRangeAnnotation) {
      NumberRangeAnnotation other = (NumberRangeAnnotation) obj;
      return MetadataTypeUtils.equals(from, other.getFrom()) && MetadataTypeUtils.equals(to, other.getTo());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return MetadataTypeUtils.hashCode(from, to);
  }
}
