/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.impl.DefaultAnyType;

public class AnyTypeBuilder<P extends TypeBuilder> extends AbstractBuilder<AnyType>
    implements TypeBuilder<AnyType>, WithAnnotation<AnyTypeBuilder> {

  protected AnyTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public AnyTypeBuilder<P> with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public AnyTypeBuilder<P> id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  @Override
  public AnyType build() {
    return new DefaultAnyType(format, annotations);
  }
}
