/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

public class BaseTypeBuilder<P extends TypeBuilder> implements TypeBuilder<MetadataType>, SimpleTypeBuilder<MetadataType> {

  private MetadataFormat format;
  private Optional<TypeBuilder<?>> builder;


  public BaseTypeBuilder(MetadataFormat format) {

    this.format = format;
    this.builder = Optional.empty();
  }

  public BaseTypeBuilder withFormat(MetadataFormat format) {
    this.format = format;
    return this;
  }

  public ObjectTypeBuilder<BaseTypeBuilder<P>> objectType() {
    final ObjectTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new ObjectTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public ArrayTypeBuilder<BaseTypeBuilder<P>> arrayType() {
    final ArrayTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new ArrayTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public DictionaryTypeBuilder<BaseTypeBuilder<P>> dictionaryType() {
    final DictionaryTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new DictionaryTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);

    return metadataBuilder;
  }

  public UnionTypeBuilder<BaseTypeBuilder<P>> unionType() {
    final UnionTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new UnionTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public TupleTypeBuilder<BaseTypeBuilder<P>> tupleType() {
    final TupleTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new TupleTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public StringTypeBuilder<BaseTypeBuilder<P>> stringType() {
    final StringTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new StringTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public BooleanTypeBuilder<BaseTypeBuilder<P>> booleanType() {
    final BooleanTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new BooleanTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public NumberTypeBuilder<BaseTypeBuilder<P>> numberType() {
    final NumberTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new NumberTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }


  public DateTimeBuilder<BaseTypeBuilder<P>> dateTimeType() {
    final DateTimeBuilder<BaseTypeBuilder<P>> metadataBuilder = new DateTimeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public DateTypeBuilder<BaseTypeBuilder<P>> dateType() {
    final DateTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new DateTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public TimeTypeBuilder<BaseTypeBuilder<P>> timeType() {
    final TimeTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new TimeTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public AnyTypeBuilder<BaseTypeBuilder<P>> anyType() {
    final AnyTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new AnyTypeBuilder<>(
                                                                                    format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public BinaryTypeBuilder<BaseTypeBuilder<P>> binaryType() {
    final BinaryTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new BinaryTypeBuilder<>(
                                                                                          format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public NullTypeBuilder<BaseTypeBuilder<P>> nullType() {
    final NullTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new NullTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public IntersectionTypeBuilder<BaseTypeBuilder<P>> intersectionType() {
    final IntersectionTypeBuilder<BaseTypeBuilder<P>> metadataBuilder = new IntersectionTypeBuilder<>(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public MetadataType build() {
    return builder.orElseThrow(() -> new RuntimeException("No type was specified.")).build();
  }

  public static BaseTypeBuilder<?> create(MetadataFormat format) {
    return new BaseTypeBuilder<>(format);
  }

}
