/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.DefaultBinaryType;

public class BinaryTypeBuilder<P extends TypeBuilder> extends AbstractBuilder<BinaryType>
    implements TypeBuilder<BinaryType>, WithAnnotation<BinaryTypeBuilder> {

  protected BinaryTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public BinaryTypeBuilder<P> with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public BinaryTypeBuilder<P> id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  @Override
  public BinaryType build() {
    return new DefaultBinaryType(format, annotations);
  }
}
