/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.DefaultDateType;

public class DateTypeBuilder<P extends TypeBuilder> extends AbstractBuilder<DateType>
    implements TypeBuilder<DateType>, WithAnnotation<DateTypeBuilder> {

  protected DateTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public DateTypeBuilder<P> with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public DateTypeBuilder<P> id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public DateTypeBuilder<P> defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }

  @Override
  public DateType build() {
    return new DefaultDateType(format, annotations);
  }
}
