/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.model.MetadataType;

public interface SimpleTypeBuilder<T extends MetadataType> extends TypeBuilder<T> {

  StringTypeBuilder<? extends SimpleTypeBuilder<T>> stringType();

  BooleanTypeBuilder<? extends SimpleTypeBuilder<T>> booleanType();

  NumberTypeBuilder<? extends SimpleTypeBuilder<T>> numberType();

  DateTimeBuilder<? extends SimpleTypeBuilder<T>> dateTimeType();

  DateTypeBuilder<? extends SimpleTypeBuilder<T>> dateType();

  AnyTypeBuilder<? extends SimpleTypeBuilder<T>> anyType();

  BinaryTypeBuilder<? extends SimpleTypeBuilder<T>> binaryType();

  NullTypeBuilder<? extends SimpleTypeBuilder<T>> nullType();
}
