/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.impl.DefaultTimeType;

public class TimeTypeBuilder<P extends TypeBuilder> extends AbstractBuilder<TimeType>
    implements TypeBuilder<TimeType>, WithAnnotation<TimeTypeBuilder> {

  protected TimeTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public TimeTypeBuilder<P> with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public TimeTypeBuilder<P> id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public TimeTypeBuilder<P> defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }

  @Override
  public TimeType build() {
    return new DefaultTimeType(format, annotations);
  }
}
