/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

/**
 * This type represents a dictionary, also known as map.
 * It's basically a set of key-value pairs or known types.
 *
 * @since 1.0
 */
public interface DictionaryType extends MetadataType {

  /**
   * @return The {@link MetadataType} for the dictionary's keys
   */
  MetadataType getKeyType();

  /**
   * @return The {@link MetadataType} for the dictionary's values
   */
  MetadataType getValueType();
}
