/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Collection;
import java.util.Map;

/**
 * Default implementation of {@link DictionaryType}
 *
 * @since 1.0
 */
public class DefaultDictionaryType extends BaseMetadataType implements DictionaryType {

  private final MetadataType keyType;
  private final MetadataType valueType;


  /**
   * Creates a new instance
   *
   * @param metadataFormat the {@link MetadataFormat}
   * @param extensions     a {@link Collection} of {@link TypeAnnotation type annotations}
   * @param keyType        the {@link MetadataType} for the dictionary's keys
   * @param valueType      the {@link MetadataType} for the dictionary's values
   */
  public DefaultDictionaryType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions,
                               MetadataType keyType, MetadataType valueType) {
    super(metadataFormat, extensions);
    this.keyType = keyType;
    this.valueType = valueType;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public MetadataType getKeyType() {
    return keyType;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public MetadataType getValueType() {
    return valueType;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitDictionary(this);
  }
}
