/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.visitor;

import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;

/**
 * Used in {@link MetadataType#accept(MetadataTypeVisitor)} as a visitor pattern.
 *
 * @see 1.0
 */
public abstract class MetadataTypeVisitor {

  /**
   * When no method matches the specific type this method will be called.
   *
   * @param metadataType The un matched MetadataType
   */
  protected void defaultVisit(MetadataType metadataType) {

  }

  public void visitSimpleType(SimpleType simpleType) {
    defaultVisit(simpleType);
  }

  public void visitAnyType(AnyType anyType) {
    defaultVisit(anyType);
  }

  public void visitArrayType(ArrayType arrayType) {
    defaultVisit(arrayType);
  }

  public void visitBinaryType(BinaryType binaryType) {
    visitSimpleType(binaryType);
  }

  public void visitBoolean(BooleanType booleanType) {
    visitSimpleType(booleanType);
  }

  public void visitDateTime(DateTimeType dateTimeType) {
    visitSimpleType(dateTimeType);
  }

  public void visitDate(DateType dateType) {
    visitSimpleType(dateType);
  }

  public void visitIntersection(IntersectionType intersectionType) {
    defaultVisit(intersectionType);
  }

  public void visitNull(NullType nullType) {
    visitSimpleType(nullType);
  }

  public void visitNumber(NumberType numberType) {
    visitSimpleType(numberType);
  }

  public void visitObject(ObjectType objectType) {
    defaultVisit(objectType);
  }

  public void visitString(StringType stringType) {
    visitSimpleType(stringType);
  }

  public void visitTime(TimeType timeType) {
    visitSimpleType(timeType);
  }

  public void visitTuple(TupleType tupleType) {
    defaultVisit(tupleType);
  }

  public void visitUnion(UnionType unionType) {
    defaultVisit(unionType);
  }

  public void visitDictionary(DictionaryType dictionaryType) {
    defaultVisit(dictionaryType);
  }

  public void visitObjectKey(ObjectKeyType objectKeyType) {
    defaultVisit(objectKeyType);
  }

  public void visitAttributeKey(AttributeKeyType attributeKeyType) {
    defaultVisit(attributeKeyType);
  }

  public void visitAttributeField(AttributeFieldType attributeFieldType) {
    defaultVisit(attributeFieldType);
  }

  public void visitObjectField(ObjectFieldType objectFieldType) {
    defaultVisit(objectFieldType);
  }
}
