/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.utils;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.model.MetadataType;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Utilities for handling values
 *
 * @since 1.0
 */
public final class MetadataTypeUtils {

  private MetadataTypeUtils() {}

  public static Optional<String> getTypeId(MetadataType metadataType) {
    return TypeIdResolver.resolveTypeId(metadataType);
  }

  public static Optional<String> getDefaultValue(MetadataType metadataType) {
    return metadataType.getAnnotation(DefaultValueAnnotation.class).map(DefaultValueAnnotation::getValue);
  }

  public static <T> boolean equals(Optional<T> left, Optional<T> right) {
    if (left.isPresent()) {
      if (!right.isPresent() || !Objects.equals(left.get(), right.get())) {
        return false;
      } else if (right.isPresent()) {
        return false;
      }
    }

    return true;
  }

  public static <T> int hashCode(Optional<T>... optionals) {
    HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
    Arrays.stream(optionals)
        .filter(Optional::isPresent)
        .forEach(n -> hashCodeBuilder.append(n.get()));

    return hashCodeBuilder.toHashCode();
  }
}
