/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.Optional;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultDictionaryType;

public class DictionaryTypeBuilder<P extends TypeBuilder>
extends AbstractBuilder<DictionaryType>
implements TypeBuilder<DictionaryType>,
WithAnnotation<DictionaryTypeBuilder> {
    private Optional<TypeBuilder<?>> keyTypeBuilder = Optional.empty();
    private Optional<TypeBuilder<?>> valueTypeBuider = Optional.empty();
    private Optional<MetadataType> keyType = Optional.empty();
    private Optional<MetadataType> valueType = Optional.empty();

    protected DictionaryTypeBuilder(MetadataFormat format) {
        super(format);
    }

    public DictionaryTypeBuilder<P> id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    public BaseTypeBuilder<?> ofKey() {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(this.format);
        this.ofKey(typeBuilder);
        return typeBuilder;
    }

    public DictionaryTypeBuilder<P> ofKey(TypeBuilder builder) {
        this.keyTypeBuilder = Optional.ofNullable(builder);
        return this;
    }

    public DictionaryTypeBuilder<P> ofKey(MetadataType type) {
        this.keyType = Optional.ofNullable(type);
        return this;
    }

    public BaseTypeBuilder<?> ofValue() {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(this.format);
        this.ofValue(typeBuilder);
        return typeBuilder;
    }

    public DictionaryTypeBuilder<P> ofValue(TypeBuilder builder) {
        this.valueTypeBuider = Optional.ofNullable(builder);
        return this;
    }

    public DictionaryTypeBuilder<P> ofValue(MetadataType type) {
        this.valueType = Optional.ofNullable(type);
        return this;
    }

    @Override
    public DictionaryTypeBuilder<P> with(TypeAnnotation extension) {
        this.addExtension(extension);
        return this;
    }

    public DictionaryTypeBuilder<P> boundary(Optional<? extends Number> minLength, Optional<? extends Number> maxLength) {
        return this.with(new LengthAnnotation(minLength, maxLength));
    }

    public DictionaryTypeBuilder<P> description(String lang, String content) {
        return this.with(new DescriptionAnnotation(Optional.of(lang), content));
    }

    public DictionaryTypeBuilder<P> description(String content) {
        return this.with(new DescriptionAnnotation(Optional.empty(), content));
    }

    public DictionaryTypeBuilder<P> label(String label) {
        return this.with(new LabelAnnotation(label));
    }

    @Override
    public DictionaryType build() {
        MetadataType key = this.keyType.isPresent() ? this.keyType.get() : this.buildOrThrow(this.keyTypeBuilder, "Key type was not specified.");
        MetadataType value = this.valueType.isPresent() ? this.valueType.get() : this.buildOrThrow(this.valueTypeBuider, "Value type was not specified.");
        return new DefaultDictionaryType(this.format, this.annotations, key, value);
    }

    private MetadataType buildOrThrow(Optional<TypeBuilder<?>> builder, String errorMessage) {
        return builder.orElseThrow(() -> new RuntimeException(errorMessage)).build();
    }
}

