/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.OpenObjectAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.utils.LazyValue;

public class ObjectTypeBuilder<P extends TypeBuilder>
extends AbstractBuilder<ObjectType>
implements TypeBuilder<ObjectType>,
WithAnnotation<ObjectTypeBuilder> {
    private List<ObjectFieldTypeBuilder<?>> fieldsBuilder = new ArrayList();
    private boolean ordered;
    private LazyValue<ObjectType> result = new LazyValue();

    public ObjectTypeBuilder(MetadataFormat format) {
        super(format);
    }

    public ObjectFieldTypeBuilder<ObjectTypeBuilder<P>> addField() {
        ObjectFieldTypeBuilder<ObjectTypeBuilder<P>> fieldMetadataBuilder = new ObjectFieldTypeBuilder<ObjectTypeBuilder<P>>(this.format);
        this.fieldsBuilder.add(fieldMetadataBuilder);
        return fieldMetadataBuilder;
    }

    public ObjectTypeBuilder<P> ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public ObjectTypeBuilder<P> id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    @Override
    public ObjectTypeBuilder<P> with(TypeAnnotation extension) {
        this.addExtension(extension);
        return this;
    }

    public ObjectTypeBuilder<P> description(String lang, String content) {
        return this.with(new DescriptionAnnotation(Optional.of(lang), content));
    }

    public ObjectTypeBuilder<P> description(String content) {
        return this.with(new DescriptionAnnotation(Optional.empty(), content));
    }

    public ObjectTypeBuilder<P> label(String label) {
        return this.with(new LabelAnnotation(label));
    }

    public ObjectTypeBuilder<P> open() {
        return this.with(new OpenObjectAnnotation());
    }

    @Override
    public ObjectType build() {
        ArrayList fields = new ArrayList();
        boolean needsInit = !this.result.isDefined();
        ObjectType objectType = this.result.get(() -> new DefaultObjectType(fields, this.ordered, this.format, this.annotations));
        if (needsInit) {
            List collect = this.fieldsBuilder.stream().map(fieldBuilder -> fieldBuilder.build()).collect(Collectors.toList());
            fields.addAll(collect);
        }
        return objectType;
    }
}

