/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.Optional;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.impl.DefaultStringType;

public class StringTypeBuilder<P extends TypeBuilder>
extends AbstractBuilder<StringType>
implements TypeBuilder<StringType>,
WithAnnotation<StringTypeBuilder> {
    protected StringTypeBuilder(MetadataFormat format) {
        super(format);
    }

    @Override
    public StringTypeBuilder<P> with(TypeAnnotation extension) {
        this.addExtension(extension);
        return this;
    }

    public StringTypeBuilder<P> id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    public StringTypeBuilder<P> defaultValue(String defaultValue) {
        return this.with(new DefaultValueAnnotation(defaultValue));
    }

    public StringTypeBuilder<P> enumOf(String ... values) {
        return this.with(new EnumAnnotation<String>(values));
    }

    public StringTypeBuilder<P> pattern(String pattern) {
        return this.with(new RegexPatternAnnotation(pattern));
    }

    @Override
    public DefaultStringType build() {
        return new DefaultStringType(this.format, this.annotations);
    }

    public StringTypeBuilder<P> boundary(Optional<? extends Number> minLength, Optional<? extends Number> maxLength) {
        return this.with(new LengthAnnotation(minLength, maxLength));
    }

    public StringTypeBuilder<P> length(Integer length) {
        return this.with(new LengthAnnotation(Optional.of(length), Optional.of(length)));
    }
}

