/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.utils;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.utils.TypeIdResolver;

public final class MetadataTypeUtils {
    private MetadataTypeUtils() {
    }

    public static Optional<String> getTypeId(MetadataType metadataType) {
        return TypeIdResolver.resolveTypeId(metadataType);
    }

    public static Optional<String> getDefaultValue(MetadataType metadataType) {
        return metadataType.getAnnotation(DefaultValueAnnotation.class).map(DefaultValueAnnotation::getValue);
    }

    public static <T> boolean equals(Optional<T> left, Optional<T> right) {
        if (left.isPresent()) {
            if (!right.isPresent() || !Objects.equals(left.get(), right.get())) {
                return false;
            }
            if (right.isPresent()) {
                return false;
            }
        }
        return true;
    }

    public static <T> int hashCode(Optional<T> ... optionals) {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        Arrays.stream(optionals).filter(Optional::isPresent).forEach(n -> hashCodeBuilder.append(n.get()));
        return hashCodeBuilder.toHashCode();
    }
}

