/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.utils;

import java.util.Optional;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

final class TypeIdResolver {
    private TypeIdResolver() {
    }

    static Optional<String> resolveTypeId(MetadataType metadataType) {
        TypeResolverVisitor visitor = new TypeResolverVisitor();
        metadataType.accept(visitor);
        return Optional.ofNullable(visitor.getResolvedTypeId());
    }

    private static class TypeResolverVisitor
    extends MetadataTypeVisitor {
        private String typeId = null;

        private TypeResolverVisitor() {
        }

        @Override
        public void visitString(StringType stringType) {
            Optional<EnumAnnotation> enumAnnotation = stringType.getAnnotation(EnumAnnotation.class);
            if (enumAnnotation.isPresent()) {
                this.defaultVisit(stringType);
            } else {
                this.typeId = String.class.getName();
            }
        }

        @Override
        public void visitObjectField(ObjectFieldType objectFieldType) {
            this.defaultVisit(objectFieldType.getValue());
        }

        @Override
        public void visitAnyType(AnyType anyType) {
            this.typeId = Object.class.getName();
        }

        @Override
        protected void defaultVisit(MetadataType metadataType) {
            this.typeId = metadataType.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).orElse(null);
        }

        public String getResolvedTypeId() {
            return this.typeId;
        }
    }
}

