/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.handler;

import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.handler.ClassHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;

public class ArrayClassHandler implements ClassHandler
{
    @Override
    public boolean handles(Class<?> clazz)
    {
        return clazz.isArray();
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz,
                                      List<Type> genericTypes, TypeHandlerManager typeHandlerManager,
                                      ParsingContext context, BaseTypeBuilder<?> typeBuilder)
    {
        final ArrayTypeBuilder<?> arrayType = typeBuilder.arrayType();
        final Class<?> componentType = clazz.getComponentType();
        final Optional<TypeBuilder<?>> mayBeType = context.getTypeBuilder(componentType);
        if (mayBeType.isPresent())
        {
            arrayType.of(mayBeType.get());
        }
        else
        {
            typeHandlerManager.handle(componentType, context, arrayType.of());
        }
        return arrayType;
    }
}
