/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.handler;

import org.mule.metadata.java.api.handler.ClassHandler;

import java.util.Arrays;
import java.util.List;

public abstract class BaseClassHandler implements ClassHandler
{

    private List<Class<?>> handledClasses;

    public BaseClassHandler(Class... handledClasses)
    {
        this.handledClasses = Arrays.asList(handledClasses);
    }

    @Override
    public boolean handles(Class<?> clazz)
    {
        for (Class<?> handledClass : handledClasses)
        {
            if (handledClass.isAssignableFrom(clazz))
            {
                return true;
            }
        }
        return false;
    }
}
