/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.internal.handler;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.List;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.internal.handler.BaseClassHandler;

public class NumberHandler
extends BaseClassHandler {
    public NumberHandler() {
        super(Integer.TYPE, Long.TYPE, Short.TYPE, Double.TYPE, Float.TYPE, Number.class);
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder<?> typeBuilder) {
        NumberTypeBuilder numberType = typeBuilder.numberType();
        if (this.isInt(clazz)) {
            numberType.integer();
        }
        if (clazz.getCanonicalName() != null) {
            numberType.id(clazz.getCanonicalName());
        }
        return numberType;
    }

    private boolean isInt(Class<?> clazz) {
        return Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz);
    }
}

