/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api;

import java.lang.reflect.Type;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.handler.DefaultTypeHandlerManagerFactory;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.handler.TypeHandlerManagerFactory;
import org.mule.metadata.java.api.utils.ParsingContext;

public class JavaTypeLoader
implements ClassTypeLoader {
    public static MetadataFormat JAVA = new MetadataFormat("Pojo", "java", new String[]{"application/java"});
    private final ClassLoader classLoader;
    private final TypeHandlerManagerFactory typeHandlerManagerFactory;

    public JavaTypeLoader(ClassLoader classLoader) {
        this(classLoader, new DefaultTypeHandlerManagerFactory());
    }

    public JavaTypeLoader(ClassLoader classLoader, TypeHandlerManagerFactory typeHandlerManagerFactory) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classloader cannot be null");
        }
        if (typeHandlerManagerFactory == null) {
            throw new IllegalArgumentException("typeHandlerManagerFactory cannot be null");
        }
        this.classLoader = classLoader;
        this.typeHandlerManagerFactory = typeHandlerManagerFactory;
    }

    public Optional<MetadataType> load(String identifier) {
        Class<?> clazz;
        if (Void.TYPE.getName().equals(identifier) || Void.class.getName().equals(identifier)) {
            return Optional.of(this.createTypeBuilder().nullType().build());
        }
        try {
            clazz = this.classLoader.loadClass(identifier);
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
        return Optional.of(this.load(clazz));
    }

    public MetadataType load(Type type) {
        BaseTypeBuilder<?> typeBuilder = this.createTypeBuilder();
        if (Void.TYPE.equals(type) || Void.class.equals((Object)type)) {
            return typeBuilder.nullType().build();
        }
        TypeHandlerManager typeHandlerManager = this.typeHandlerManagerFactory.createTypeHandlerManager();
        typeHandlerManager.handle(type, new ParsingContext(), typeBuilder);
        return typeBuilder.build();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private BaseTypeBuilder<?> createTypeBuilder() {
        return BaseTypeBuilder.create((MetadataFormat)JAVA);
    }
}

