/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.handler;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.handler.ClassHandler;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.api.utils.TypeResolver;
import org.mule.metadata.java.internal.handler.ArrayClassHandler;
import org.mule.metadata.java.internal.handler.BinaryHandler;
import org.mule.metadata.java.internal.handler.BooleanHandler;
import org.mule.metadata.java.internal.handler.CollectionClassHandler;
import org.mule.metadata.java.internal.handler.DateHandler;
import org.mule.metadata.java.internal.handler.DateTimeHandler;
import org.mule.metadata.java.internal.handler.EnumHandler;
import org.mule.metadata.java.internal.handler.MapClassHandler;
import org.mule.metadata.java.internal.handler.NumberHandler;
import org.mule.metadata.java.internal.handler.ObjectHandler;
import org.mule.metadata.java.internal.handler.StringHandler;

public class TypeHandlerManager {
    private final List<ClassHandler> handlers;

    private TypeHandlerManager(ClassHandler ... handlers) {
        this.handlers = Arrays.asList(handlers);
    }

    public void handle(Type type, ParsingContext context, BaseTypeBuilder<?> typeBuilder) {
        if (type instanceof Class) {
            TypeBuilder<?> builder = this.handleClass((Class)type, Collections.emptyList(), context, typeBuilder);
            context.addTypeBuilder(type, builder);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Class<?> raw = TypeResolver.erase(type);
            context.addResolvedVariables(TypeResolver.resolveVariables(type));
            TypeBuilder<?> builder = this.handleClass(raw, Arrays.asList(paramType.getActualTypeArguments()), context, typeBuilder);
            context.addTypeBuilder(type, builder);
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            ArrayTypeBuilder arrayTypeBuilder = typeBuilder.arrayType();
            this.handle(arrayType.getGenericComponentType(), context, arrayTypeBuilder.of());
        } else if (type instanceof TypeVariable) {
            Type actual = context.getResolvedVariables().get(type);
            if (actual == null || type.equals(actual)) {
                TypeVariable typeVariable = (TypeVariable)type;
                Type[] bounds = typeVariable.getBounds();
                if (bounds.length > 0) {
                    this.handle(bounds[0], context, typeBuilder);
                } else {
                    typeBuilder.anyType();
                }
            } else {
                this.handle(actual, context, typeBuilder);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildType = (WildcardType)type;
            Type[] lowerBounds = wildType.getLowerBounds();
            Type[] upperBounds = wildType.getUpperBounds();
            if (lowerBounds.length > 0) {
                this.handle(lowerBounds[0], context, typeBuilder);
            } else if (upperBounds.length > 0) {
                this.handle(upperBounds[0], context, typeBuilder);
            } else {
                typeBuilder.anyType();
            }
        } else {
            throw new IllegalArgumentException("Unsupported type " + type);
        }
    }

    private TypeBuilder<?> handleClass(Class<?> type, List<Type> genericTypes, ParsingContext context, BaseTypeBuilder<?> typeBuilder) {
        for (ClassHandler handler : this.handlers) {
            if (!handler.handles(type)) continue;
            return handler.handleClass(type, genericTypes, this, context, typeBuilder);
        }
        return typeBuilder.anyType();
    }

    public static TypeHandlerManager createDefault() {
        return TypeHandlerManager.create(new ObjectHandler(new DefaultObjectFieldHandler()));
    }

    public static TypeHandlerManager create(ObjectHandler objectHandler) {
        return new TypeHandlerManager(new BinaryHandler(), new DateHandler(), new DateTimeHandler(), new EnumHandler(), new MapClassHandler(), new NumberHandler(), new MapClassHandler(), new NumberHandler(), new StringHandler(), new ArrayClassHandler(), new BooleanHandler(), new CollectionClassHandler(), objectHandler);
    }
}

