/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.utils;

import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.utils.MetadataTypeUtils;

public final class JavaTypeUtils {
    private JavaTypeUtils() {
    }

    public static <T> Class<T> getType(MetadataType metadataType) {
        return JavaTypeUtils.getType(metadataType, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> getType(MetadataType metadataType, ClassLoader classLoader) {
        if (metadataType instanceof NullType) {
            return Void.TYPE;
        }
        Optional typeId = MetadataTypeUtils.getTypeId((MetadataType)metadataType);
        if (!typeId.isPresent()) {
            throw new IllegalArgumentException("metadataType does not contain a type annotation");
        }
        try {
            return ClassUtils.getClass((ClassLoader)classLoader, (String)((String)typeId.get()), (boolean)true);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class " + (String)typeId.get(), e);
        }
    }

    public static Optional<MetadataType> getGenericTypeAt(ObjectType objectType, int index, ClassTypeLoader typeLoader) {
        Optional classInformationAnnotation = objectType.getAnnotation(ClassInformationAnnotation.class);
        if (!classInformationAnnotation.isPresent() || ((ClassInformationAnnotation)classInformationAnnotation.get()).getGenericTypes().size() <= index) {
            return Optional.empty();
        }
        return typeLoader.load(((ClassInformationAnnotation)classInformationAnnotation.get()).getGenericTypes().get(index));
    }
}

