/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.internal.handler;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.DictionaryTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.handler.ClassHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

public class MapClassHandler
implements ClassHandler {
    @Override
    public boolean handles(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder<?> typeBuilder) {
        DictionaryTypeBuilder dictionaryType = typeBuilder.dictionaryType().id(clazz.getName());
        if (genericTypes.isEmpty()) {
            dictionaryType.ofKey().anyType();
            dictionaryType.ofValue().anyType();
        } else {
            if (genericTypes.size() != 2) {
                throw new IllegalArgumentException(String.format("Exactly 2 generics were expected but %d were provided instead", genericTypes.size()));
            }
            this.parseGenericType(genericTypes.get(0), arg_0 -> ((DictionaryTypeBuilder)dictionaryType).ofKey(arg_0), () -> ((DictionaryTypeBuilder)dictionaryType).ofKey(), context, typeHandlerManager);
            this.parseGenericType(genericTypes.get(1), arg_0 -> ((DictionaryTypeBuilder)dictionaryType).ofValue(arg_0), () -> ((DictionaryTypeBuilder)dictionaryType).ofValue(), context, typeHandlerManager);
        }
        return dictionaryType;
    }

    private void parseGenericType(Type genericType, Consumer<TypeBuilder<?>> typeConsumer, Supplier<BaseTypeBuilder<?>> fallbackType, ParsingContext context, TypeHandlerManager typeHandlerManager) {
        Optional<TypeBuilder<?>> keyTypeBuilder = context.getTypeBuilder(genericType);
        if (keyTypeBuilder.isPresent()) {
            typeConsumer.accept(keyTypeBuilder.get());
        } else {
            typeHandlerManager.handle(genericType, context, fallbackType.get());
        }
    }
}

