/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.example;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.JsonTypeLoader;

import com.google.gson.JsonElement;

import java.util.Arrays;
import java.util.List;

public class HandlerManager
{

    List<? extends JsonElementHandler> handlers = Arrays.asList(new ArrayHandler(), new ObjectHandler(), new PrimitiveHandler(), new NullHandler());

    public TypeBuilder<?> handle(JsonElement jsonElement, ParsingContext parsingContext)
    {
        for (JsonElementHandler handler : handlers)
        {
            if (handler.handles(jsonElement))
            {
                return handler.handle(jsonElement, BaseTypeBuilder.create(JsonTypeLoader.JSON), this, parsingContext);
            }
        }
        // If no type was detected we just generate any
        return BaseTypeBuilder.create(JsonTypeLoader.JSON).anyType();
    }
}
