/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.example;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import java.util.Map;

public class ObjectHandler implements JsonElementHandler
{

    @Override
    public boolean handles(JsonElement jsonElement)
    {
        return jsonElement.isJsonObject();
    }

    @Override
    public TypeBuilder<?> handle(JsonElement jsonElement, BaseTypeBuilder<?> root, HandlerManager handlerManager, ParsingContext parsingContext)
    {
        JsonObject object = (JsonObject) jsonElement;

        ObjectTypeBuilder<? extends BaseTypeBuilder<?>> objectTypeBuilder = root.objectType();

        parsingContext.getAnnotations().forEach(objectTypeBuilder::with);

        for (Map.Entry<String, JsonElement> member : object.entrySet())
        {
            final ObjectFieldTypeBuilder<?> field = objectTypeBuilder.addField();
            field.key(member.getKey());
            final JsonElement value = member.getValue();
            field.value(handlerManager.handle(value, new ParsingContext()));
        }
        return objectTypeBuilder;
    }
}
