/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.handler;

import org.everit.json.schema.NullSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

public class NullHandler implements SchemaHandler
{
    @Override
    public boolean handles(Schema schema)
    {
        return schema instanceof NullSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder<?> root, HandlerManager handlerManager, ParsingContext parsingContext)
    {
        return root.nullType();
    }
}
