/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.handler;

import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.Optional;

public class StringHandler implements SchemaHandler
{
    @Override
    public boolean handles(Schema schema)
    {
        return schema instanceof StringSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder<?> root, HandlerManager handlerManager, ParsingContext parsingContext)
    {
        final StringSchema stringSchema = (StringSchema) schema;
        final StringTypeBuilder<?> stringType = root.stringType();

        Optional<Integer> min = Optional.empty();
        Optional<Integer> max = Optional.empty();

        if (stringSchema.getMinLength() != null && stringSchema.getMinLength() > 0)
        {
            min = Optional.of(stringSchema.getMinLength());
        }

        if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() > 0)
        {
            max = Optional.of(stringSchema.getMaxLength());
        }
        if (min.isPresent() || max.isPresent())
        {
            stringType.boundary(min, max);
        }

        if (stringSchema.getPattern() != null)
        {
            stringType.pattern(stringSchema.getPattern().toString());
        }
        return stringType;
    }
}
