/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.example;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.example.HandlerManager;
import org.mule.metadata.json.example.JsonElementHandler;
import org.mule.metadata.json.example.ParsingContext;

public class PrimitiveHandler
implements JsonElementHandler {
    @Override
    public boolean handles(JsonElement jsonElement) {
        return jsonElement.isJsonPrimitive();
    }

    @Override
    public TypeBuilder<?> handle(JsonElement jsonElement, BaseTypeBuilder<?> root, HandlerManager handlerManager, ParsingContext parsingContext) {
        JsonPrimitive primitive = (JsonPrimitive)jsonElement;
        if (primitive.isString()) {
            return root.stringType();
        }
        if (primitive.isBoolean()) {
            return root.booleanType();
        }
        if (primitive.isNumber()) {
            String stringValue = primitive.getAsString();
            if (this.isInteger(stringValue)) {
                return root.numberType().id("int");
            }
            if (this.isDouble(stringValue)) {
                return root.numberType().id("double");
            }
            return root.numberType();
        }
        return root.stringType();
    }

    private boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isDouble(String input) {
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

