/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json;

import org.everit.json.schema.*;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.json.handler.HandlerManager;
import org.mule.metadata.json.handler.ParsingContext;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

public class JsonTypeLoader implements TypeLoader {

  public static MetadataFormat JSON = new MetadataFormat("Json", "json", "text/json", "application/json");
  private File schemaFile;

  public JsonTypeLoader(File schemaFile) {
    this.schemaFile = schemaFile;
  }

  @Override
  public Optional<MetadataType> load(String identifier) {
    try {
      try (InputStream inputStream = new FileInputStream(schemaFile)) {
        final JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
        final Schema jsonSchema = SchemaLoader.load(rawSchema);
        return Optional.of(new HandlerManager().handle(jsonSchema, new ParsingContext()).build());
      }
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
}
