/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.handler;

import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.Optional;

public class NumberHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof NumberSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder<?> root, HandlerManager handlerManager,
                               ParsingContext parsingContext) {
    final NumberSchema numberSchema = (NumberSchema) schema;
    final NumberTypeBuilder<?> numberType = root.numberType();
    Optional<Number> min = Optional.empty();
    Optional<Number> max = Optional.empty();
    if (numberSchema.getMinimum() != null) {
      min = Optional.of(numberSchema.getMinimum());
    }
    if (numberSchema.getMaximum() != null) {
      max = Optional.of(numberSchema.getMaximum());
    }
    if (min.isPresent() || max.isPresent()) {
      numberType.range(min, max);
    }

    if (numberSchema.requiresInteger()) {
      numberType.integer();
    }
    return numberType;
  }
}
